//	 2005 Colter Reed, Procyon IT.  All rights reserved.
//	
//	This software is provided as-is with no warranty of any kind, express or implied.
//	You may reverse-engineer it to your heart's content to figure out how it works.
//	You may use any of this code in your own projects, provided that you give credit
//	to Colter Reed and Procyon IT.  If you make any modifications to this program,
//	especially bug fixes and new functions, send them to me -- we'll see if we can
//	incorporate them into a future version.
//	
//	Thanks, and have fun.



function parseFraction(x) {
	var MAX_ITERATIONS = 20;
	
	//document.writeln("Called parseFraction(" + x + ")");

	//document.writeln("Testing " + x + " for near-integrity...");
	
	if (nearlyInteger(x)) {
		//document.writeln(x + " is nearly an integer.  Returning " + x + " now.");
		return x;
	}
	
	//document.writeln(x + " is not nearly an integer.  Continuing to process.");
	
	var s = new Array();	// This will store our sequence of denominators
	//document.writeln("s: " + s);
	var temp = Math.abs(x);	//	A temp copy to work on
	var c = 1;				//	How many iterations have we been through?
	
	//document.writeln("");
	//document.writeln("Before iteration:");
	//document.writeln("\ttemp: " + temp);
	
	while (!nearlyInteger(temp) && c <= MAX_ITERATIONS) {
		var tempInt = Math.round(temp - 0.5);		//	Get the integer part of temp
		s[c] = tempInt;							//	This is our next denominator
		//document.writeln("integer part of " + temp + " is " + tempInt);
		
		temp = temp-tempInt;					//	Get the fractional part
		temp = 1 / temp;						//	Take the reciprocal of the decimal part
		
		//document.writeln("Iteration " + c + ":");
		//document.writeln("\ts.length:" + s.length);
		//document.writeln("\ts: " + s.join(","));
		
		c += 1;									//	Increment our iteration counter
	}
	s[c] = Math.round(temp * 100000) / 100000;	//	This is within our tolerance, so...
	
//	Now, why did we stop?

//	If we stopped because we had too many iterations, then our answer
//	is going to be dubious anyway, so just return x
	if (c > MAX_ITERATIONS) {
		//document.writeln("MAX_ITERATIONS reached.  Returning " + x);
		return x;
	}
	
//	We must have found an answer!
//	Reconstruct the rational number from the entries in the partial fraction

	//document.writeln("We have found an answer.");

	var n = 1;				// Our numerator-to-be
	var d = s[c];			//	Our denomiator-to-be. Start with the last denominator
	//document.writeln("s: " + s.join(", "));
	//document.writeln("Reconstructed fraction: " + n + "/" + d);
	
	for(var k = c-1; k >= 2; k--) {
		var t = d * s[k] + n;			//	Our next numerator
		n = d;						//	Our next denominator
		d = t;						//	We're taking the reciprocal, so swap n <-> d
	}
	
	var w = s[1];						//	The whole number part
	
	if (stack) {
		//stack.push("w:"+w);
		//stack.push("n:"+n);
		//stack.push("d:"+d);
		
		//stack.push("s:" + typeof(s));
	}
	
//	See if our answer agrees with what we started with
	var myX = w + n / d;
	if (Math.abs(Math.abs(myX/x) - 1) < 0.0000001) {
	//	It matches to within 1e-7.  Close enough.
		var f = n + "/" + d;
		if (w != 0) {
			f = w + " " + f;
		}
		if (x < 0) {
			f = "-" + f;
		}
		return f;
	}
	
//	We just couldn't do it.  Sigh.
	return x;
}

function nearlyInteger(x) {
	ni = Math.abs(x - Math.round(x)) < 0.00001;
	//document.writeln(x + (ni ? " is" : " is not") + " nearly an integer");
	return ni;
}

function parseFromFraction(f) {
	if (m=f.match(/^(.+) ([0-9]+)\/([0-9]+)$/)) {
		var sign = m[1] < 0 ? "-" : "";
		return sign + (Math.abs(m[1]) + m[2]/m[3]);
	}
	
	if (m=f.match(/^([-+]?[0-9]+)\/([0-9]+)$/)) {
		var sign = m[1] < 0 ? "-" : "";
		return sign + (Math.abs(m[1]) / m[2]);
	}
	
	return parseFloat(f);
}

